<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Twig;

use Gls\GlsPoland\Carrier\TrackingUrlGeneratorInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

final class GlsPolandExtension extends AbstractExtension
{
    private $urlGenerator;

    public function __construct(TrackingUrlGeneratorInterface $urlGenerator)
    {
        $this->urlGenerator = $urlGenerator;
    }

    public function getFilters(): array
    {
        return [
            new TwigFilter('gls_poland_tracking_url', [$this, 'getTrackingUrl']),
        ];
    }

    public function getTrackingUrl(string $parcelNumber): string
    {
        return $this->urlGenerator->generate($parcelNumber);
    }
}
