<?php

declare(strict_types=1);

namespace Gls\GlsPoland\MessageHandler\Labels\Download;

use Gls\GlsPoland\AdePlus\Pickup\ClientInterface;
use Gls\GlsPoland\AdePlus\Printout\LabelsPrintMode;
use Gls\GlsPoland\AdePlus\Printout\PrintoutInterface;
use Gls\GlsPoland\Entity\Consignment;

final class PickupDownloadLabelsHandler extends AbstractDownloadLabelsHandler
{
    private $client;

    public function __construct(ClientInterface $client)
    {
        $this->client = $client;
    }

    public function downloadSingle(Consignment $consignment, LabelsPrintMode $printMode): PrintoutInterface
    {
        if (null === $consignment->getPickupId()) {
            return parent::downloadSingle($consignment, $printMode);
        }

        return $this->client->getLabels($consignment->getAdeConsignmentId(), $printMode);
    }

    public function downloadSeparate(Consignment $consignment, LabelsPrintMode $printMode): iterable
    {
        if (null === $consignment->getPickupId()) {
            return parent::downloadSeparate($consignment, $printMode);
        }

        return $this->client->getSeparateLabels($consignment->getAdeConsignmentId(), $printMode);
    }
}
