<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Services;

use Gls\GlsPoland\Soap\Client\Type\ResultInterface;

final class MaxParcelWeights implements ResultInterface, \JsonSerializable
{
    /**
     * @var float
     */
    private $weight_max_national;

    /**
     * @var float
     */
    private $weight_max_international;

    public function getMaxDomesticWeightKg(): float
    {
        return $this->weight_max_national;
    }

    public function getMaxInternationalWeightKg(): float
    {
        return $this->weight_max_international;
    }

    public function jsonSerialize(): array
    {
        return get_object_vars($this);
    }
}
