<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Pickup;

use Gls\GlsPoland\AdePlus\Client as AdePlusClient;
use Gls\GlsPoland\AdePlus\Common\Id;
use Gls\GlsPoland\AdePlus\Consignment\Consignment;
use Gls\GlsPoland\AdePlus\Consignment\ConsignmentIdsCollection;
use Gls\GlsPoland\AdePlus\Printout\Labels;
use Gls\GlsPoland\AdePlus\Printout\LabelsCollection;
use Gls\GlsPoland\AdePlus\Printout\LabelsPrintMode;
use Gls\GlsPoland\AdePlus\Printout\PickupReceipt;
use Gls\GlsPoland\AdePlus\Printout\PickupReceiptPrintMode;

final class Client implements ClientInterface
{
    private $client;

    public function __construct(AdePlusClient $client)
    {
        $this->client = $client;
    }

    public function createPickup(string $description, int ...$consignmentIds): Id
    {
        $params = new Create(
            new ConsignmentIdsCollection(...$consignmentIds),
            $description
        );

        return $this->client->pickupCreate($params);
    }

    public function getConsignmentIdsBindings(int $pickupId): iterable
    {
        $params = new GetConsignmentBindings($pickupId);

        return $this->client->pickupGetConsignmentBindings($params);
    }

    public function getReceipt(int $pickupId, PickupReceiptPrintMode $printMode): PickupReceipt
    {
        $params = new GetReceipt($pickupId, $printMode);

        return $this->client->pickupGetReceipt($params);
    }

    public function isSandbox(): bool
    {
        return $this->client->isSandbox();
    }

    public function getConsignment(int $id): Consignment
    {
        $params = new GetConsignment($id);

        return $this->client->pickupGetConsignment($params);
    }

    public function getLabels(int $consignmentId, LabelsPrintMode $printMode): Labels
    {
        $params = new GetConsignmentLabels($consignmentId, $printMode);

        return $this->client->pickupGetConsignmentLabels($params);
    }

    public function getSeparateLabels(int $consignmentId, LabelsPrintMode $printMode): LabelsCollection
    {
        $params = new GetConsignmentLabelsExt($consignmentId, $printMode);

        return $this->client->pickupGetConsignmentLabelsExt($params);
    }
}
