<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Consignment;

final class IDENTOptions
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $country;

    /**
     * @var string
     */
    private $zipcode;

    /**
     * @var string
     */
    private $city;

    /**
     * @var string
     */
    private $street;

    /**
     * @var \DateTimeInterface
     */
    private $date_birth;

    /**
     * @var string
     */
    private $identity;

    /**
     * @var int
     */
    private $ident_doctype;

    /**
     * @var string
     */
    private $nation;

    /**
     * @var string
     */
    private $national_idnum;

    /**
     * @var int
     */
    private $spages;

    /**
     * @var int
     */
    private $ssign;

    /**
     * @var int
     */
    private $sdealsend;

    /**
     * @var int
     */
    private $sdealrec;

    public function getName(): string
    {
        return $this->name;
    }

    public function withName(string $name): IDENTOptions
    {
        $new = clone $this;
        $new->name = $name;

        return $new;
    }

    public function getCountry(): string
    {
        return $this->country;
    }

    public function withCountry(string $country): IDENTOptions
    {
        $new = clone $this;
        $new->country = $country;

        return $new;
    }

    public function getZipcode(): string
    {
        return $this->zipcode;
    }

    public function withZipcode(string $zipcode): IDENTOptions
    {
        $new = clone $this;
        $new->zipcode = $zipcode;

        return $new;
    }

    public function getCity(): string
    {
        return $this->city;
    }

    public function withCity(string $city): IDENTOptions
    {
        $new = clone $this;
        $new->city = $city;

        return $new;
    }

    public function getStreet(): string
    {
        return $this->street;
    }

    public function withStreet(string $street): IDENTOptions
    {
        $new = clone $this;
        $new->street = $street;

        return $new;
    }

    public function getDate_birth(): \DateTimeInterface
    {
        return $this->date_birth;
    }

    public function withDate_birth(\DateTimeInterface $date_birth): IDENTOptions
    {
        $new = clone $this;
        $new->date_birth = $date_birth;

        return $new;
    }

    public function getIdentity(): string
    {
        return $this->identity;
    }

    public function withIdentity(string $identity): IDENTOptions
    {
        $new = clone $this;
        $new->identity = $identity;

        return $new;
    }

    public function getIdent_doctype(): int
    {
        return $this->ident_doctype;
    }

    public function withIdent_doctype(int $ident_doctype): IDENTOptions
    {
        $new = clone $this;
        $new->ident_doctype = $ident_doctype;

        return $new;
    }

    public function getNation(): string
    {
        return $this->nation;
    }

    public function withNation(string $nation): IDENTOptions
    {
        $new = clone $this;
        $new->nation = $nation;

        return $new;
    }

    public function getNational_idnum(): string
    {
        return $this->national_idnum;
    }

    public function withNational_idnum(string $national_idnum): IDENTOptions
    {
        $new = clone $this;
        $new->national_idnum = $national_idnum;

        return $new;
    }

    public function getSpages(): int
    {
        return $this->spages;
    }

    public function withSpages(int $spages): IDENTOptions
    {
        $new = clone $this;
        $new->spages = $spages;

        return $new;
    }

    public function getSsign(): int
    {
        return $this->ssign;
    }

    public function withSsign(int $ssign): IDENTOptions
    {
        $new = clone $this;
        $new->ssign = $ssign;

        return $new;
    }

    public function getSdealsend(): int
    {
        return $this->sdealsend;
    }

    public function withSdealsend(int $sdealsend): IDENTOptions
    {
        $new = clone $this;
        $new->sdealsend = $sdealsend;

        return $new;
    }

    public function getSdealrec(): int
    {
        return $this->sdealrec;
    }

    public function withSdealrec(int $sdealrec): IDENTOptions
    {
        $new = clone $this;
        $new->sdealrec = $sdealrec;

        return $new;
    }
}
