<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Common;

use Gls\GlsPoland\Soap\Client\Type\ResultInterface;

/**
 * @implements \IteratorAggregate<int, string>
 */
final class StringArray implements ResultInterface, \JsonSerializable, \IteratorAggregate
{
    /**
     * @var string[]
     */
    private $items;

    public function getItems(): array
    {
        return $this->items;
    }

    /**
     * @return \Iterator<int, string>
     */
    public function getIterator(): \Iterator
    {
        return new \ArrayIterator($this->items);
    }

    public function jsonSerialize(): array
    {
        return $this->items;
    }
}
